##
## Create actor dummies
## 
# ActorType: A coding for the type of actor. More specifically, we employ the following scheme:
#     *1: State (in UCDP dyadic, this actor type is called 'Side A')
#     *2: State A2 (in UCDP dyadic, this actor type is called 'Side A2nd'). These are states supporting the state (1) involved with conflict on its territory.
#     3: Rebel (in UCDP dyadic, the actor type is called 'Side B')
#         - in UCDP: SideB; when type==2 (interstate war), this actor is also a STATE, not a rebel! 
#     *4: State supporting rebels in other country (in UCDP dyadic, this actor type is called 'SideB2nd').
#     6: Pro-government militias (PGMs)

# state (1) / non-state dummy (2)
Master$actor_type_state <- 0 # is a non-state actor (SideA2 = PGM; SideB = Rebel)
Master$actor_type_state[Master$actor_type == 1 | 
                          Master$actor_type == 2 | 
                          (Master$actor_type == 3 & Master$type==2) | 
                          Master$actor_type == 4] <- 1

# finer-grained actor dummies (also divided in state / non-state for actor_type == 3 (SideB / Rebels))
# actor_type_sideA should be used as ref. category! 
Master$actor_type_sideA <- 0 
Master$actor_type_sideA[Master$actor_type == 1] <- 1

Master$actor_type_sideA2nd <- 0
Master$actor_type_sideA2nd[Master$actor_type == 2] <- 1

Master$actor_type_sideA_PGM <- 0
Master$actor_type_sideA_PGM[Master$actor_type == 6] <- 1

Master$actor_type_sideB_state <- 0
Master$actor_type_sideB_state[Master$actor_type == 3 & Master$type == 2] <- 1

Master$actor_type_sideB_rebel <- 0
Master$actor_type_sideB_rebel[Master$actor_type == 3 & Master$type != 2] <- 1

Master$actor_type_sideB2nd <- 0
Master$actor_type_sideB2nd[Master$actor_type == 4] <- 1